/**
 * Commonly used signals across different elements and documents.
 * @enum {string}
 */
export const CommonSignals_Enum = {
    /**
     * The element's implementation has been registered and ready for upgrade.
     */
    READY_TO_UPGRADE: 'ready-upgrade',

    /**
     * The element has been upgraded from ElementStub to its real implementation.
     */
    UPGRADED: 'upgraded',

    /**
     * The element has been built.
     */
    BUILT: 'built',

    /**
     * The element has been mounted.
     */
    MOUNTED: 'mounted',

    /**
     * The element has started loading.
     * LOAD_START triggers at the start of the layoutCallback.
     */
    LOAD_START: 'load-start',

    /**
     * Rendering has been confirmed to have been started.
     * It is a signal to indicate meaningful display (e.g. text could be displayed
     * CSS is correctly installed/applied).
     *
     * Elements can optionally implement RENDER_START signal. (e.g. ad, shadowdoc)
     * if it want to define its own meaningful display time and toggle visibility.
     *
     * Simpler elements's RENDER_START can be equal to the start of the
     * buildCallback
     */
    RENDER_START: 'render-start',

    /**
     * The element has been loaded.
     * LOAD_END triggers at the end of the layoutCallback.
     *
     */
    LOAD_END: 'load-end',

    /**
     * The initial contents of an element/document/embed have been loaded.
     * INI_LOAD is an optional signal, implemented by ads, story, and elements
     * that consist of other resources.
     * It instructs that all critical resources has been loaded, and can be used
     * for more accurate visibility measurement.
     * When an element doesn't consist multiple child resources, LOAD_END signal
     * can be used to indicate resource load completion.
     * Note: Based on the implementation, INI_LOAD can trigger before or after
     * LOAD_END.
     */
    INI_LOAD: 'ini-load',

    /**
     * The element has been unlaid out.
     */
    UNLOAD: 'unload',
};